/*
 * LlistarClients.java
 *
 * Created on 8 de junio de 2008, 16:52
 */

package actions;

import entitats.Client;
import entitats.OpcionsClient;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;
/**
 *
 * @author Administrador
 * @version
 */

public class LlistarClients extends Action {
    
    DataSource ds = null;
    Connection con = null;
    String sql;
    ArrayList <Client> clients = new ArrayList();
    String success = "propietarisVenedor";
    
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        OpcionsClient opcions = (OpcionsClient) form;
        clients.clear();
        
        try{
            ds = this.getDataSource(request);
            con = ds.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = null;
            PreparedStatement sentencia = null;
            success = opcions.getLlistar();
            opcions.getTipusClient();
            
            if (opcions.getLlistar().equals("llogaters"))
                sql = "SELECT * FROM clients WHERE es_llogater = 1";
            else
                sql = "SELECT * FROM clients WHERE es_propietari = 1";
            
            if (!opcions.isEmpresa() && !opcions.isParticular()){
                opcions.setError("<font color='red'>S'ha de seleccionar com a minim un tipus de client</font>");
                return mapping.findForward(success);
            }
            
            if (!opcions.isEmpresa() || !opcions.isParticular()){
                if (opcions.isEmpresa())
                    sql += " AND tipus = 'empresa'";
                else if (opcions.isParticular())
                    sql += " AND tipus = 'persona'";
            }
            
            rs = st.executeQuery(sql);
            
            if (rs.next()) {
                do{
                    Client client = new Client();
                    client.setAdresa(rs.getString("adresa"));
                    client.setNif(rs.getString("nif"));
                    client.setTelefon(rs.getString("telefon"));
                    client.setNom(rs.getString("nom_o_rao_social"));
                    client.setCognoms(rs.getString("cognoms"));
                    client.setIdClient(rs.getInt("id"));
                    
                    //Si es llogater o propietari per mes tard ajudar a llistar
                    if (opcions.getLlistar().equals("llogaters"))
                        client.setLlogater(true);
                    else
                        client.setPropietari(true);
                    
                    //PREFERENCIES LLOGATERS
                    client.setIdZona(rs.getInt("preferencies_id_zona"));
                    client.setSuperficieMinima(rs.getFloat("preferencies_superficie_minima"));
                    client.setTipusLocal(rs.getString("preferencies_tipus_local"));
                    clients.add(client);
                } while (rs.next());
            } else {
                opcions.setLlista("<b>La cerca no ha donat resultats</b>");
                return mapping.findForward(success);
            }
            
            for (Client client : clients) {
                //Per saber quants locals te en propietat
                rs = st.executeQuery("SELECT COUNT(*) FROM locals WHERE id_propietari = "+client.getIdClient());
                rs.next();
                client.setLocalsEnPosesio(rs.getInt(1));
                
                //Per saber quants locals te llogats
                rs = st.executeQuery("SELECT COUNT(*) FROM contractes WHERE id_client = "+client.getIdClient());
                rs.next();
                client.setLocalsLlogats(rs.getInt(1));
            }
            
            opcions.setLlistatClients(clients);
            
        }catch(Exception excepcio){
            System.out.println("ERROR: "+excepcio.getMessage());
            opcions.setError("<font color='red'>Excepcio ocorreguda en actions.LlistarClients:<br>" +
                    ""+excepcio.getMessage()+"</font>");
            
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception excepcio){
                opcions.setError("<font color='red'>Excepcio ocorreguda en actions.LlistarClients:<br>" +
                        ""+excepcio.getMessage()+"</font>");
                return mapping.findForward(success);
            }
        }
        return mapping.findForward(success);
    }
}